<?php
namespace MailPoetVendor\Doctrine\DBAL\Driver\PDO;
if (!defined('ABSPATH')) exit;
use MailPoetVendor\Doctrine\DBAL\Driver\Exception\UnknownParameterType;
use MailPoetVendor\Doctrine\DBAL\Driver\Result as ResultInterface;
use MailPoetVendor\Doctrine\DBAL\Driver\Statement as StatementInterface;
use MailPoetVendor\Doctrine\DBAL\ParameterType;
use MailPoetVendor\Doctrine\Deprecations\Deprecation;
use PDOException;
use PDOStatement;
use function array_slice;
use function func_get_args;
use function func_num_args;
final class Statement implements StatementInterface
{
 private PDOStatement $stmt;
 public function __construct(PDOStatement $stmt)
 {
 $this->stmt = $stmt;
 }
 public function bindValue($param, $value, $type = ParameterType::STRING)
 {
 if (func_num_args() < 3) {
 Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/5558', 'Not passing $type to Statement::bindValue() is deprecated.' . ' Pass the type corresponding to the parameter being bound.');
 }
 $pdoType = ParameterTypeMap::convertParamType($type);
 try {
 return $this->stmt->bindValue($param, $value, $pdoType);
 } catch (PDOException $exception) {
 throw Exception::new($exception);
 }
 }
 public function bindParam($param, &$variable, $type = ParameterType::STRING, $length = null, $driverOptions = null) : bool
 {
 Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/5563', '%s is deprecated. Use bindValue() instead.', __METHOD__);
 if (func_num_args() < 3) {
 Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/5558', 'Not passing $type to Statement::bindParam() is deprecated.' . ' Pass the type corresponding to the parameter being bound.');
 }
 if (func_num_args() > 4) {
 Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4533', 'The $driverOptions argument of Statement::bindParam() is deprecated.');
 }
 $pdoType = ParameterTypeMap::convertParamType($type);
 try {
 return $this->stmt->bindParam($param, $variable, $pdoType, $length ?? 0, ...array_slice(func_get_args(), 4));
 } catch (PDOException $exception) {
 throw Exception::new($exception);
 }
 }
 public function execute($params = null) : ResultInterface
 {
 if ($params !== null) {
 Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/5556', 'Passing $params to Statement::execute() is deprecated. Bind parameters using' . ' Statement::bindParam() or Statement::bindValue() instead.');
 }
 try {
 $this->stmt->execute($params);
 } catch (PDOException $exception) {
 throw Exception::new($exception);
 }
 return new Result($this->stmt);
 }
}
